/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.tags.hmc;

import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.ExpressionEnabled;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmListModel;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmTableModel;
import com.ibm.hwmca.fw.util.Trace;
import javax.servlet.jsp.tagext.TagSupport;

public class HMCModelExpressionHandler
extends TagSupport {
    private static final String TRACE_MASK = "XTAGMEX";
    private static final String TRACE_MASKD = "XTAGMEXD";
    private static final String TRACE_MASKF = "XTAGMEXF";
    private static final String TRACE_MASKT = "XTAGMEXT";
    public static final String TYPE_LIST = "list";
    public static final String TYPE_TABLE = "table";
    public static final String TYPE_MENU = "menu";
    private String modelID;
    private String modelType;
    private String text;
    private int index;
    private static final String PANEL_MODEL = "panelModel";

    public int doStartTag() {
        PanelModel panelModel = this.getActivePanelModel();
        if (this.modelType.equals(TYPE_LIST)) {
            PmListModel listModel = panelModel.getListModel(this.modelID);
            if (listModel == null) {
                throw new IllegalArgumentException("List model ID specified (" + this.modelID + ") can not be found.");
            }
            if (!(listModel instanceof ExpressionEnabled)) {
                throw new IllegalArgumentException("List model ID specified (" + this.modelID + ") is not an ExpressionEnabled model");
            }
            ((ExpressionEnabled)((Object)listModel)).setExpression(this.text, this.index);
        } else if (this.modelType.equals(TYPE_TABLE)) {
            PmTableModel tableModel = panelModel.getTableModel(this.modelID);
            if (tableModel == null) {
                throw new IllegalArgumentException("Table model ID specified (" + this.modelID + ") can not be found.");
            }
            if (!(tableModel instanceof ExpressionEnabled)) {
                throw new IllegalArgumentException("Table model ID specified (" + this.modelID + ") is not an ExpressionEnabled model");
            }
            ((ExpressionEnabled)((Object)tableModel)).setExpression(this.text, this.index);
        } else if (this.modelType.equals(TYPE_MENU)) {
            Object target = panelModel.getImplAccess().getScope().getAttribute(this.modelID);
            if (target == null || !(target instanceof ExpressionEnabled)) {
                throw new IllegalArgumentException("Menu target is null (wasn't in scope) or dosn't implement ExpressionEnabled");
            }
            panelModel.getImplAccess().getScope().removeAttribute(this.modelID);
            ((ExpressionEnabled)target).setExpression(this.text, 0);
        }
        return 1;
    }

    public int doEndTag() {
        return 6;
    }

    public void setModelID(String modelID) {
        Trace.trace(TRACE_MASKT, "-> setModelID(" + modelID + ")");
        if (modelID == null || modelID.equals("")) {
            throw new IllegalArgumentException("Model ID argument must be non-null & non-empty");
        }
        this.modelID = modelID;
        Trace.trace(TRACE_MASKT, "<- setModelID(" + modelID + ")");
    }

    public void setModelType(String modelType) {
        Trace.trace(TRACE_MASKT, "-> setModelType(" + modelType + ")");
        if (modelType == null) {
            modelType = "";
        }
        if (modelType.equals(TYPE_LIST)) {
            this.modelType = TYPE_LIST;
        } else if (modelType.equals(TYPE_MENU)) {
            this.modelType = TYPE_MENU;
        } else if (modelType.equals(TYPE_TABLE)) {
            this.modelType = TYPE_TABLE;
        } else {
            throw new IllegalArgumentException("Model type must be one of: [list, menu, table]");
        }
        Trace.trace(TRACE_MASKT, "<- setModelType(" + modelType + ")");
    }

    public void setText(String text) {
        Trace.trace(TRACE_MASKT, "-> setText(" + text + ")");
        this.text = text == null ? "" : text;
        Trace.trace(TRACE_MASKT, "<- setText(" + text + ")");
    }

    public void setIndex(String index) {
        Trace.trace(TRACE_MASKT, "-> setIndex(" + index + ")");
        try {
            this.index = Integer.parseInt(index);
            if (this.index < 0) {
                throw new IllegalArgumentException();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Index (" + index + ") specified was not an integer >= 0");
        }
        Trace.trace(TRACE_MASKT, "<- setIndex(" + index + ")");
    }

    private PanelModel getActivePanelModel() {
        PanelModel model = (PanelModel)this.pageContext.getAttribute(PANEL_MODEL);
        return model;
    }
}

